//+------------------------------------------------------------------+
//|                                                  LeadingSign.mq5 |
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
//---  
#property copyright "Copyright  2015, Nikolay Kositsin"
//---    
#property link      "farria@mail.redcom.ru"
//---   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 2
//---     
#property indicator_plots   2
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0   //        
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---         
#property indicator_color1  clrMagenta
//---    1  4
#property indicator_width1  4
//---    
#property indicator_label1  "LeadingSign Sell"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---         
#property indicator_color2  clrLime
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2 "LeadingSign Buy"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input double Alpha1 = 0.25;    // 1  
input double Alpha2 = 0.33;    // 2   
//+----------------------------------------------+
//---   ,    
//---        
double SellBuffer[];
double BuyBuffer[];
//---      
int ATR_Handle;
//---      
int min_rates_total;
//+------------------------------------------------------------------+
//|                               |
//+------------------------------------------------------------------+   
double Get_Price(const double  &High[],const double  &Low[],int bar)
  {
//---
   return((High[bar]+Low[bar])/2);
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---    
   int ATR_Period=15;
   min_rates_total=int(MathMax(ATR_Period,2));
//---    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(0,PLOT_ARROW,171);
//---       
   ArraySetAsSeries(SellBuffer,true);
//---      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(1,PLOT_ARROW,171);
//---       
   ArraySetAsSeries(BuyBuffer,true);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---         
   string short_name="LeadingSign";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//---    
   int to_copy,limit,bar,maxbar;
   double Lead,NetLead,EMA,ATR[];
//---        
   static double Lead_,NetLead_,EMA_;
//---     
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-1; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
   to_copy=limit+1;
   maxbar=rates_total-min_rates_total;
//---       ATR[]
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);
//---         
   ArraySetAsSeries(ATR,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
//---   
   Lead=Lead_;
   NetLead=NetLead_;
   EMA=EMA_;
//---    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---        
      if(rates_total!=prev_calculated && bar==rates_total-1)
         Lead_=Lead;
      //---
      if(bar<maxbar)
        {
         Lead=2.0*Get_Price(high,low,bar)+(Alpha1-2.0)*Get_Price(high,low,bar+1)+(1.0-Alpha1)*Lead_;
         NetLead=Alpha2*Lead+(1-Alpha2)*NetLead_;
         EMA=0.5*Get_Price(high,low,bar)+0.5*EMA_;
        }
      else
        {
         Lead=Get_Price(high,low,bar);
         NetLead=Lead;
         EMA=Lead;
         if(bar)
           {
            NetLead_=NetLead;
            Lead_=Lead;
            EMA_=EMA;
           }
         continue;
        }
      //---
      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;
      //---
      if(EMA_>Lead_ && EMA<Lead) BuyBuffer[bar]=low[bar]-ATR[bar]*3/8;
      if(EMA_<Lead_ && EMA>Lead) SellBuffer[bar]=high[bar]+ATR[bar]*3/8;
      //---
      if(bar)
        {
         NetLead_=NetLead;
         Lead_=Lead;
         EMA_=EMA;
        }
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
