//+------------------------------------------------------------------+
//|                                           LaguerreFilterSign.mq5 |
//|                                                                  |
//| Laguerre Filter                                                  |
//|                                                                  |
//| Algorithm taken from book                                        |
//|     "Cybernetics Analysis for Stock and Futures"                 |
//| by John F. Ehlers                                                |
//|                                                                  |
//|                                              contact@mqlsoft.com |
//|                                          http://www.mqlsoft.com/ |
//+------------------------------------------------------------------+
//----  
#property copyright "Coded by Witold Wozniak"
//----  
#property link      "www.mqlsoft.com"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 2
//----     
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---        
#property indicator_color1  clrMagenta
//---    1  4
#property indicator_width1  4
//---    
#property indicator_label1  "LaguerreFilter Sell"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---        
#property indicator_color2  clrBlue
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2 "LaguerreFilter Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input double Gamma=0.7;//   
input int Shift=0; //       
//+----------------------------------------------+
//----      
int min_rates_total;
//----   ,    
//      
double SellBuffer[],BuyBuffer[];
//----      
int ATR_Handle;
//+------------------------------------------------------------------+
//|                               |
//+------------------------------------------------------------------+   
double Get_Price(const double  &High[],const double  &Low[],int bar)
// Get_Price(high, low, bar)
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
  {
//----
   return((High[bar]+Low[bar])/2);
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   int ATR_Period=15;
   min_rates_total=int(MathMax(ATR_Period,4));

//----    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }

//----      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(0,PLOT_ARROW,172);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);

//----      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(1,PLOT_ARROW,172);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//----    2    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);

//----      
   string shortname;
   StringConcatenate(shortname,"Laguerre Filter(",DoubleToString(Gamma,4),", ",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);

//----    
   int first,bar;
   double L0,L1,L2,L3,L0A,L1A,L2A,L3A,Laguerre,Fir,ATR[1];

//----        
   static double L0_,L1_,L2_,L3_,L0A_,L1A_,L2A_,L3A_,Laguerre_,Fir_;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=0; //      
   else first=prev_calculated-1; //      

//----   
   L0 = L0_;
   L1 = L1_;
   L2 = L2_;
   L3 = L3_;
   L0A = L0A_;
   L1A = L1A_;
   L2A = L2A_;
   L3A = L3A_;

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {

      L0A = L0;
      L1A = L1;
      L2A = L2;
      L3A = L3;
      //----
      L0 = (1 - Gamma) * Get_Price(high, low, bar) + Gamma * L0A;
      L1 = - Gamma * L0 + L0A + Gamma * L1A;
      L2 = - Gamma * L1 + L1A + Gamma * L2A;
      L3 = - Gamma * L2 + L2A + Gamma * L3A;
      //----
      if(bar>min_rates_total)
        {
         Laguerre=(L0+2.0*L1+2.0*L2+L3)/6.0;
         Fir=
             (
             1.0*Get_Price(high,low,bar-0)
             +2.0*Get_Price(high,low,bar-1)
             +2.0*Get_Price(high,low,bar-2)
             +1.0*Get_Price(high,low,bar-3)
             )
             /6.0;
        }
      else
        {
         L0_=Get_Price(high,low,bar);
         L1_ = L0_;
         L2_ = L0_;
         L3_ = L0_;
         Laguerre=Fir=L0_;
        }

      SellBuffer[bar]=0.0;
      BuyBuffer[bar]=0.0;

      if(Fir_<=Laguerre_ && Fir>Laguerre)
        {
         if(CopyBuffer(ATR_Handle,0,time[bar],1,ATR)<=0)  return(RESET);
         BuyBuffer[bar]=low[bar]-ATR[0]*3/8;
        }
      if(Fir_>=Laguerre_ && Fir<Laguerre)
        {
         if(CopyBuffer(ATR_Handle,0,time[bar],1,ATR)<=0)  return(RESET);
         SellBuffer[bar]=high[bar]+ATR[0]*3/8;
        }

      //----   
      if(rates_total!=prev_calculated && bar==rates_total-2)
        {
         L0_ = L0;
         L1_ = L1;
         L2_ = L2;
         L3_ = L3;
         L0A_ = L0A;
         L1A_ = L1A;
         L2A_ = L2A;
         L3A_ = L3A;
        }

      if(bar<rates_total-1)
        {
         Laguerre_=Laguerre;
         Fir_=Fir;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
