//+------------------------------------------------------------------+
//|                                              DSSBressertSign.mq5 |
//|                      Copyright  2008, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2008, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net/"
//----   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 2
//---     
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---         
#property indicator_color1  clrMagenta
//---    1  5
#property indicator_width1  5
//---    
#property indicator_label1  "DSSBressertSign Sell"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---         
#property indicator_color2  clrLimeGreen
//---    2  5
#property indicator_width2  5
//---    
#property indicator_label2 "DSSBressertSign Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint  EMA_period=8;  // EMA
input uint  Sto_period=13; // 
input int   Shift=0;       //     
//+----------------------------------------------+
//----      
int min_rates_total;
//---   ,         
double SellBuffer[],BuyBuffer[];
//----   
double smooth_coefficient;
//----      
int ATR_Handle;
//----   
int Count[];
double Mit[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)
  {
//----
   int numb,Max1,Max2;
   static int count=1;

   Max2=Size;
   Max1=Max2-1;

   count--;
   if(count<0) count=Max1;

   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
//----
  }
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//---    ATR
   int ATR_Period=12;
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//----     
   min_rates_total=int(MathMax(ATR_Period,Sto_period+1));
//----     
   smooth_coefficient=2.0/(1.0+EMA_period);
//----       
   ArrayResize(Count,Sto_period);
   ArrayResize(Mit,Sto_period);
//---      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(0,PLOT_ARROW,170);
//---       
   ArraySetAsSeries(SellBuffer,true);
//---      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(1,PLOT_ARROW,170);
//---       
   ArraySetAsSeries(BuyBuffer,true);
//----      
   string shortname;
   StringConcatenate(shortname,"DSS Bressert(",EMA_period,", ",Sto_period,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//---       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);

//----       
   double HighRange,LowRange,delta,MIT,DSS,Dss,ATR[],diff;
   static double Dss_prev;
//----        
   int to_copy,limit,bar;

//----         
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(close,true);
   ArraySetAsSeries(ATR,true);

//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      ArrayInitialize(Count,0);
      ArrayInitialize(Mit,50.0);
      Dss_prev=50;
     }
   else limit=rates_total-prev_calculated; //      
   to_copy=limit+1;

//---       ATR[]
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);

//----     Mit
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      HighRange=high[ArrayMaximum(high,bar,Sto_period)];
      LowRange=low[ArrayMinimum(low,bar,Sto_period)];
      delta=close[bar]-LowRange;
      diff=(HighRange-LowRange)*100.0;
      if(!diff) diff=_Point*100.0;
      MIT=delta/(HighRange-LowRange)*100.0;
      Mit[Count[0]]=smooth_coefficient*(MIT-Mit[Count[1]])+Mit[Count[1]];
      HighRange=Mit[ArrayMaximum(Mit,0,Sto_period)];
      LowRange=Mit[ArrayMinimum(Mit,0,Sto_period)];
      delta=Mit[Count[0]]-LowRange;
      DSS=delta/(HighRange-LowRange)*100.0;
      Dss=smooth_coefficient*(DSS-Dss_prev)+Dss_prev;
      //---
      BuyBuffer[bar]=NULL;
      SellBuffer[bar]=NULL;
      //---
      if(Mit[Count[1]]<=Dss_prev && Mit[Count[0]]>Dss) BuyBuffer[bar]=low[bar]-ATR[bar]*3/8;
      if(Mit[Count[1]]>=Dss_prev && Mit[Count[0]]<Dss) SellBuffer[bar]=high[bar]+ATR[bar]*3/8;
      //---
      if(bar<rates_total-1)
        {
         Dss_prev=Dss;
         Recount_ArrayZeroPos(Count,Sto_period);
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
