//+------------------------------------------------------------------+
//|                                             CGOscillatorSign.mq5 |
//|                                                                  |
//| CG Oscillator                                                    |
//|                                                                  |
//| Algorithm taken from book                                        |
//|     "Cybernetics Analysis for Stock and Futures"                 |
//| by John F. Ehlers                                                |
//|                                                                  |
//|                                              contact@mqlsoft.com |
//|                                          http://www.mqlsoft.com/ |
//+------------------------------------------------------------------+
//----  
#property copyright "Coded by Witold Wozniak"
//----  
#property link      "www.mqlsoft.com"
//----   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 2
//---    
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---        Red 
#property indicator_color1  clrRed
//---    1  4
#property indicator_width1  4
//---    
#property indicator_label1  "CGOscillator Sell"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---        Blue 
#property indicator_color2  clrBlue
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2 "CGOscillator Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int Length=10;//   
input int Shift=0;  //       
//+----------------------------------------------+
//---   ,   
//---      
double SellBuffer[],BuyBuffer[];
//----      
int min_rates_total;
//----   
double CGshift;
//---      
int ATR_Handle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   min_rates_total=Length;
   int ATR_Period=10;
   min_rates_total=int(MathMax(min_rates_total,ATR_Period));
//----    
   CGshift=(Length+1.0)/2.0;
//---    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(0,PLOT_ARROW,172);
//---    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(1,PLOT_ARROW,172);
//---    1  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   string shortname;
   StringConcatenate(shortname,"CGOscillatorSign(",Length,", ",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----    
   int first,bar;
   double price,Num,Denom,CG,Trigger,ATR[1];
   static double CG1,Trigger1;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=min_rates_total; //      
     }
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      Num=0.0;
      Denom=0.0;
      //----
      for(int count=0; count<Length; count++)
        {
         price=(high[bar-count]+low[bar-count])/2.0;
         Num += (1.0 + count) * price;
         Denom+=price;
        }
      if(Denom!=0.0) CG=-Num/Denom+CGshift;
      else  CG=0.0;
      //----
      Trigger=CG1;
      //--- 
      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;
      //---
      if(CG1<Trigger1 && CG>Trigger)
        {
         //---      
         if(CopyBuffer(ATR_Handle,0,time[bar],1,ATR)<=0) return(RESET);
         BuyBuffer[bar]=low[bar]-ATR[0]*3/8;
        }
      //---
      if(CG1>Trigger1 && CG<Trigger)
        {
         //---      
         if(CopyBuffer(ATR_Handle,0,time[bar],1,ATR)<=0) return(RESET);
         SellBuffer[bar]=high[bar]+ATR[0]*3/8;
        }
      //---
      if(bar<rates_total-1)
        {
         CG1=CG;
         Trigger1=Trigger;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
