//+------------------------------------------------------------------+
//|                                                          RWM.MQ4 |
//|        ,      |
//|                           Copyright  2006, HomeSoft Tartan Corp |
//|	                                           spiky@transkeino.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006 Maloma"
#property link      "maloma@datasvit.net"

#property indicator_chart_window
#property indicator_buffers 8
#property indicator_color5 Blue
#property indicator_color6 Red
#property indicator_color7 Blue
#property indicator_color8 Red

double W_Buffer0[];
double W_Buffer1[];
double R_Buffer0[];
double R_Buffer1[];
double S_Buffer0[];
double S_Buffer1[];
double E_Buffer0[];
double E_Buffer1[];
int    R_t3_period=21;
double R_b=0.8;
extern int    R_mBar=0;
double W_e1, W_e2, W_e3, W_e4, W_e5, W_e6, W_c1, W_c2, W_c3, W_c4, W_n, W_w1, W_w2, W_b2, W_b3;
double W_t3, W_shift, W_wpr, W_trig, W_t3_period, W_b, W_per, W_psel, W_pbuy;
bool   R_ft=True;
double R_e1, R_e2, R_e3, R_e4, R_e5, R_e6, R_c1, R_c2, R_c3, R_c4, R_n, R_w1, R_w2, R_b2, R_b3;
double R_t3[];
int    R_LoopBegin, R_shift;

int init()
  {
//---- indicators
  SetIndexStyle     (0,DRAW_NONE);
  SetIndexBuffer    (0,W_Buffer0);
  SetIndexEmptyValue(0,EMPTY_VALUE);
  
  SetIndexStyle     (1,DRAW_NONE);
  SetIndexBuffer    (1,W_Buffer1);
  SetIndexEmptyValue(1,EMPTY_VALUE);
   
  SetIndexStyle     (2,DRAW_NONE);
  SetIndexBuffer    (2,R_Buffer0);
  SetIndexEmptyValue(2,EMPTY_VALUE);
  
  SetIndexStyle     (3,DRAW_NONE);
  SetIndexBuffer    (3,R_Buffer1);
  SetIndexEmptyValue(3,EMPTY_VALUE);
  
  SetIndexStyle     (4,DRAW_ARROW,EMPTY,2);
  SetIndexArrow     (4,241);
  SetIndexBuffer    (4,S_Buffer0);
  SetIndexEmptyValue(4,EMPTY_VALUE);
  
  SetIndexStyle     (5,DRAW_ARROW,EMPTY,2);
  SetIndexArrow     (5,242);
  SetIndexBuffer    (5,S_Buffer1);
  SetIndexEmptyValue(5,EMPTY_VALUE);
  
  SetIndexStyle     (6,DRAW_ARROW,EMPTY,2);
  SetIndexArrow     (6,251);
  SetIndexBuffer    (6,E_Buffer0);
  SetIndexEmptyValue(6,EMPTY_VALUE);
  
  SetIndexStyle     (7,DRAW_ARROW,EMPTY,2);
  SetIndexArrow     (7,251);
  SetIndexBuffer    (7,E_Buffer1);
  SetIndexEmptyValue(7,EMPTY_VALUE);
  
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   W_t3_period=8;
   W_b=0.8;
   W_per=21;
   W_psel=-30;
   W_pbuy=-70;
   W_b2=W_b*W_b;
   W_b3=W_b2*W_b;
   W_c1=-W_b3;
   W_c2=(3*(W_b2+W_b3));
   W_c3=-3*(2*W_b2+W_b+W_b3);
   W_c4=(1+3*W_b+W_b3+3*W_b2);
   W_n=W_t3_period;

   if (W_n<1) W_n=1;
   W_n = 1 + 0.5*(W_n-1);
   W_w1 = 2 / (W_n + 1);
   W_w2 = 1 - W_w1;
   
   if (R_mBar==0) R_LoopBegin=Bars;
   else R_LoopBegin=R_mBar;
   R_LoopBegin=MathMin(R_LoopBegin, Bars);
   for(int i=0; i<R_LoopBegin; i++)
   {
      W_wpr=iWPR(NULL,0,W_per,i);
 
      W_e1 = W_w1*W_wpr + W_w2*W_e1;
      W_e2 = W_w1*W_e1 + W_w2*W_e2;
      W_e3 = W_w1*W_e2 + W_w2*W_e3;
      W_e4 = W_w1*W_e3 + W_w2*W_e4;
      W_e5 = W_w1*W_e4 + W_w2*W_e5;
      W_e6 = W_w1*W_e5 + W_w2*W_e6;
      W_t3 = W_c1*W_e6 + W_c2*W_e5 + W_c3*W_e4 + W_c4*W_e3;
      
      if (W_t3>=-50) W_trig=W_psel; 
      
      if (W_t3<-50) W_trig=W_pbuy;
      
      W_Buffer0[i]=W_t3;
      
      W_Buffer1[i]=W_trig;
   }
   
  if (R_mBar==0) R_LoopBegin=Bars-R_t3_period-1;
  else R_LoopBegin=R_mBar;
  R_LoopBegin=MathMin(R_LoopBegin, Bars-R_t3_period-1);

  ArrayResize(R_t3, R_LoopBegin);

  if (R_ft) {
    R_b2=R_b*R_b;
    R_b3=R_b2*R_b;
    R_c1=-R_b3;
    R_c2=(3*(R_b2+R_b3));
    R_c3=-3*(2*R_b2+R_b+R_b3);
    R_c4=(1+3*R_b+R_b3+3*R_b2);
    R_n=R_t3_period;

    if (R_n<1) R_n=1;
    R_n=1+0.5*(R_n-1);
    R_w1=2/(R_n+1);
    R_w2=1-R_w1;
    R_ft=False;
  }

  for (R_shift=R_LoopBegin; R_shift>=0; R_shift--) {
    R_e1=R_w1*Close[R_shift]+R_w2*R_e1;
    R_e2=R_w1*R_e1+R_w2*R_e2;
    R_e3=R_w1*R_e2+R_w2*R_e3;
    R_e4=R_w1*R_e3+R_w2*R_e4;
    R_e5=R_w1*R_e4+R_w2*R_e5;
    R_e6=R_w1*R_e5+R_w2*R_e6;

    R_t3[R_shift]=R_c1*R_e6+R_c2*R_e5+R_c3*R_e4+R_c4*R_e3;
    if (R_t3[R_shift+1]<=R_t3[R_shift]) R_Buffer0[R_shift]=R_t3[R_shift]; else R_Buffer0[R_shift]=0;
    if (R_t3[R_shift+1]>R_t3[R_shift]) R_Buffer1[R_shift]=R_t3[R_shift]; else R_Buffer1[R_shift]=0;
  }

  if (R_mBar==0) R_LoopBegin=Bars-R_t3_period-1;
  else R_LoopBegin=R_mBar;
  R_LoopBegin=MathMin(R_LoopBegin, Bars-R_t3_period-1);
  for (int cnt=0;cnt<=R_LoopBegin;cnt++)
   {
    if(R_Buffer0[cnt]>0 && R_Buffer1[cnt+1]>0 && W_Buffer0[cnt]>W_Buffer0[cnt+1] && W_Buffer0[cnt+1]>W_psel) S_Buffer0[cnt]=Low[cnt]-6*Point; else S_Buffer0[cnt]=0;
    if(R_Buffer1[cnt]>0 && R_Buffer0[cnt+1]>0 && W_Buffer0[cnt]<W_Buffer0[cnt+1] && W_Buffer0[cnt+1]<W_pbuy) S_Buffer1[cnt]=High[cnt]+6*Point; else S_Buffer1[cnt]=0;
   }
  
  if (R_mBar==0) R_LoopBegin=Bars-R_t3_period-1;
  else R_LoopBegin=R_mBar;
  R_LoopBegin=MathMin(R_LoopBegin, Bars-R_t3_period-1);
  for (cnt=0;cnt<=R_LoopBegin;cnt++)
   {
    if(W_Buffer0[cnt]<W_psel && W_Buffer0[cnt+1]>W_psel) E_Buffer0[cnt]=High[cnt]+6*Point; else E_Buffer0[cnt]=0;
    if(W_Buffer0[cnt]>W_pbuy && W_Buffer0[cnt+1]<W_pbuy) E_Buffer1[cnt]=Low[cnt]-6*Point; else E_Buffer1[cnt]=0;
   }

   return(0);
  }
//+------------------------------------------------------------------+